#include"Indata_function.h"

map<double, double> MAP = { {0.5,0}, {0.9,1.28}, {0.95,1.625}, {0.975,1.96},{0.99,2.33}, {0.995,2.57} };

normaltable calc_normaltable(const NN_data& nn_data, const User_parameter& user_parameter, struct app1_indata* indata, int mode) { 	normaltable nt;
	memset(&nt, 0, sizeof(nt));
	for(int l=0;l<n_label;l++)
	for (int j = 0; j < user_parameter.n_internal_test_case; j++) {
		double max = -5000000, secmax = -5000000;
		for (int i = 0; i < nn_data.n_class; i++) {
			if (nn_data.test_case_ccon_w[l][i][j] > max) {
				secmax = max;
				max = nn_data.test_case_ccon_w[l][i][j];
			}
			else secmax = secmax > nn_data.test_case_ccon_w[l][i][j] ? secmax : nn_data.test_case_ccon_w[l][i][j];
		}
		for (int i = 0; i < nn_data.n_class; i++) {
			if (nn_data.test_case_ccon_w[l][i][j] + user_parameter.xi > max) {
				nt.table[l][nn_data.ans[l][j]<3][i][1]++;
				nt.table_eff[l][i][j][1] = 1;
			}
			if (nn_data.test_case_ccon_w[l][i][j] - user_parameter.xi > secmax) {
				nt.table[l][nn_data.ans[l][j]<3][i][0]++;
				nt.table_eff[l][i][j][0] = 1;
			}
		}
	}
	return nt;
}

normalclass calc_normalclass(const NN_data& nn_data, struct app1_indata* indata) { 	normalclass nc;
	memset(&nc, 0, sizeof(indata->nc));
	for(int l=0;l<n_label;l++)
		for (int j = 0; j < nn_data.n_sample; j++) {
			double max = -5000000;
			for (int i = 0; i < nn_data.n_class; i++) {
				if (nn_data.ccon_w_batch[l][i][j] > max) {
					nc.nclass[l][j] = i;
					max = nn_data.ccon_w_batch[l][i][j];
				}
			}
		}
	return nc;
}

posterior calc_posterior(const NN_data& nn_data, const User_parameter& user_parameter, struct app1_indata* indata, normaltable nt) { 	posterior p;
	memset(&p, 0, sizeof(p));
		double prior_denom = 0; 		for (int l = 0;l < n_label;l++)
		{
			for (int k = 0; k < user_parameter.n_rank; k++) prior_denom += user_parameter.context[l][k]; 			for (int j = 0; j < nn_data.n_class; j++) {
				double denominator = 0.00000001;
				for (int k = 0; k < user_parameter.n_rank; k++)
				{
					denominator += ((double)user_parameter.context[l][k] / prior_denom) * nt.table[l][k][j][0] / (nn_data.ans_sum[l][k] + 0.00000001); 									}
				for (int k = 0; k < user_parameter.n_rank; k++)
					p.postprob[l][j][k] = ((((double)user_parameter.context[l][k] / prior_denom) * nt.table[l][k][j][1]) / (nn_data.ans_sum[l][k] + 0.00000001)+0.00000001) / denominator;
			}
		}
	return p;
}
